// XISLOprTag.cpp: CXISLOprTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLOprTag.h"
#include "XISLInputTag.h"
#include "XISLCombInputTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLOprTag::CXISLOprTag(CXISLTag *pParent,int nComb,LPCTSTR lpszURI)
{
	m_pParentTag = pParent;

	m_nTagType = ID_TAG_OPERATION;
	m_nComb = nComb;
	m_strTarget = lpszURI;
}

CXISLOprTag::~CXISLOprTag()
{
	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);
		if(pOprItem->m_nTagType == ID_TAG_INPUT)
			delete (CXISLInputTag*)pOprItem;
		else
			delete (CXISLCombInputTag*)pOprItem;
	}
}

CXISLOprTag::CXISLOprTag(const CXISLOprTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_InputList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_InputList.FindIndex(i);
		m_InputList.AddTail(cpXISL.m_InputList.GetAt(pos));
	}
	m_nComb = cpXISL.m_nComb;
	m_strTarget = cpXISL.m_strTarget;
}

CXISLOprTag& CXISLOprTag::operator=(const CXISLOprTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0; i<m_InputList.GetCount(); i++)
		{
			POSITION pos = m_InputList.FindIndex(i);
			CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);
			if(pOprItem->m_nTagType == ID_TAG_INPUT)
				delete (CXISLInputTag*)pOprItem;
			else
				delete (CXISLCombInputTag*)pOprItem;
		}
		m_InputList.RemoveAll();
		for(i=0; i<cpXISL.m_InputList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_InputList.FindIndex(i);
			m_InputList.AddTail(cpXISL.m_InputList.GetAt(pos));
		}
		m_nComb = cpXISL.m_nComb;
		m_strTarget = cpXISL.m_strTarget;
	}
	return *this;
}


void CXISLOprTag::InsertOprItem(CXISLOprItem *pTag,CXISLTag *pPlaceTag)
{
	if(pPlaceTag)
	{
		POSITION pos = m_InputList.Find(pPlaceTag);
		if(pos)
		{
			//D&Dꂽ̂inputȂ
			if(pTag->m_nTagType == ID_TAG_INPUT)
			{
				//drop***_inputȂł
				if((pPlaceTag->m_nTagType!=ID_TAG_PINPUT && pPlaceTag->m_nTagType!=ID_TAG_AINPUT
					&& pPlaceTag->m_nTagType!=ID_TAG_SINPUT))
					ASSERT(NULL);
				
				((CXISLCombInputTag*)pPlaceTag)->InsertOprItem(pTag);
			}
			//D&Dꂽ̂***_inputȂ
			else if(pTag->m_nTagType == ID_TAG_PINPUT || pTag->m_nTagType == ID_TAG_SINPUT
				|| pTag->m_nTagType == ID_TAG_AINPUT)
			{
				pTag->m_pParentTag = m_pParentTag;
				m_InputList.InsertAfter(pos,pTag);
				m_InputList.RemoveAt(pos);
				((CXISLCombInputTag*)pTag)->InsertOprItem((CXISLOprItem*)pPlaceTag);
			}
		}
		else
			ASSERT(NULL);
	}
	else
	{
		m_InputList.AddTail(pTag);
		pTag->m_pParentTag = m_pParentTag;
	}
}

//Cvbg̍폜
BOOL CXISLOprTag::DeleteOprItem(CXISLOprItem *pTag,CXISLTag *pPlaceTag)
{
	POSITION pos = m_InputList.Find(pTag);
	if(pos==NULL)return FALSE;
	POSITION posdel = pos;
	m_InputList.RemoveAt(posdel);
	delete pTag;
	pTag=NULL;
	return TRUE;
/*	POSITION pos = m_InputList.GetHeadPosition();
	if(m_InputList.IsEmpty())return FALSE;
	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION posPrev = pos;
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);		
		if(pOprItem==pTag){
			m_InputList.RemoveAt(posPrev);
			return TRUE;
		}
	}*/
}

//LPCTSTR CXISLOprTag::GetXISLString()
//@\@FoperationȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLOprTag::GetXISLString()
{
	CString strComb = XISL_COMB[m_nComb];
	m_strXISL = "<operation comb=\"";
	m_strXISL += strComb;
	if(!m_strTarget.IsEmpty())
	{
		m_strXISL += "\" target=\"";
		m_strXISL += m_strTarget;
	}
	m_strXISL += "\">\r\n";

	if(m_InputList.IsEmpty())
	{
		m_strXISL += "</operation>\r\n";
		return m_strXISL;
	}

	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);
		m_strXISL += pOprItem->GetXISLString();
	}
	m_strXISL += "</operation>\r\n";
	return m_strXISL;
}


//int CXISLExchangeTag::GetItemCount()
//@\@FexchangeȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLOprTag::GetItemCount()
{
	int nCount = 0;
	if((nCount = m_InputList.GetCount()) != 0)
		nCount++;  //<operation>̕

	return nCount;
}

//BOOL CXISLOprTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLOprTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OPERATION];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	for(int i=0; i<m_InputList.GetCount(); i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

		pOprItem->RegistXISLTree(pTree,hParent);
		/*
		if(pOprItem->m_nTagType == ID_TAG_INPUT)
			((CXISLInputTag*)pOprItem)->RegistXISLTree(pTree,hParent);
		else
			(CXISLCombInputTag*)pOprItem;
			*/
	}

	return TRUE;
}

/*
//CXISLInputTag* CXISLOprTag::CreateInput(int nType, LPCTSTR lpszEvent,
//							  LPCTSTR lpszMatch, LPCTSTR lpszNameList)
//@\@F<input>쐬
//@Fint nType			:̓_eB̃^Cv
//		  LPCTSTR lpszEvent :̓Cxg
//		  LPCTSTR lpszMatch :}b`
//		  LPCTSTR lpszNameList:namelist
//ԂlFCXISLInputTag*@sFNULL
CXISLInputTag* CXISLOprTag::CreateInput(int nType, LPCTSTR lpszEvent,
							  LPCTSTR lpszMatch, LPCTSTR lpszNameList)
{
	CXISLInputTag *pInputTag;
	pInputTag = new CXISLInputTag((CXISLTag*)m_pParentTag,nType,lpszEvent,lpszMatch,lpszNameList);

	pInputTag->m_nTagID = m_nInputNum;
	m_nInputNum++;
	m_InputList.AddTail(pInputTag);

	return pInputTag;
}
*/

//CSize CXISLOprTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Foperation̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLOprTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->MoveTo(nX,nY);
	nY += 10;
	pDC->LineTo(nX,nY);

	int nCount = m_InputList.GetCount();
	if(nCount == 0)
		return CSize(nX,nY);

	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;
	CBitmap *pOldBMP;
	
	POINT point[3];
	int nBX = nX;
	int nBY = nY;
	nY += 10;
	int *npInputPoint = new int[nCount];
	for(int i=0;i<nCount;i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem *pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

		FlowBMP.LoadBitmap(pOprItem->m_nBmpID);
		FlowBMP.GetBitmap(&bmp);
		if(i==0)
		{
			pOldBMP = MemDC.SelectObject(&FlowBMP);
			if(m_nComb != ID_XISLCOMB_SEQ)
			{
				nX = nX - (bmp.bmWidth - 10);
				nY += 50;
			}
		}
		else
			MemDC.SelectObject(&FlowBMP);
		pDC->BitBlt(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
		pOprItem->SetRectBMP(nX-bmp.bmWidth/2,nY,bmp.bmWidth,bmp.bmHeight);
		npInputPoint[i] = nX;
		nViewSizeX = nX + bmp.bmWidth/2;

		pDC->MoveTo(nBX,nBY);
		if(m_nComb != ID_XISLCOMB_SEQ)
		{
			if(i == 0)
			{
				point[0].x = nBX;
				point[0].y = nBY+20;
				point[1].x = nX-10;
				point[1].y = nBY+20;
				point[2].x = nX;
				point[2].y = nY;
			}
			else
			{
				point[0].x = nBX;
				point[0].y = nBY+20;
				point[1].x = nX+10;
				point[1].y = nBY+20;
				point[2].x = nX;
				point[2].y = nY;
			}
			pDC->PolyBezierTo(point,3);
			//`
			pDC->MoveTo(nX+4,nY-6);
			pDC->LineTo(nX,nY);
			pDC->MoveTo(nX-4,nY-6);
			pDC->LineTo(nX,nY);
			nX = nX + bmp.bmWidth + 20;
		}
		else
		{
			pDC->LineTo(nX,nY);
			nBX = nX; nBY = nY + bmp.bmHeight;
			//`
			pDC->MoveTo(nX+4,nY-6);
			pDC->LineTo(nX,nY);
			pDC->MoveTo(nX-4,nY-6);
			pDC->LineTo(nX,nY);
			nY = nY + bmp.bmHeight + 20;
		}
		FlowBMP.DeleteObject();
	}

	if(m_nComb == ID_XISLCOMB_SEQ)
	{
		pDC->MoveTo(nBX,nBY);
		nY += 10;
		pDC->LineTo(nX,nY);
	}
	else
	{
		nX = nBX;
		nY += bmp.bmHeight;
		nBY = nY; 
		if(m_nComb == ID_XISLCOMB_PAR)
		{
			nY += 20;
			for(int i=0;i<nCount;i++)
			{
				pDC->MoveTo(npInputPoint[i],nBY);
				pDC->LineTo(npInputPoint[i],nY);
			}
			pDC->MoveTo(npInputPoint[0],nY);
			if(nCount == 1)
				pDC->LineTo(nBX,nY);
			else
				pDC->LineTo(npInputPoint[nCount-1],nY);
			pDC->MoveTo(nBX,nY);
			nY += 30;
			pDC->LineTo(nBX,nY);
		}
		else if(m_nComb == ID_XISLCOMB_ALT)
		{
			nY += 60;
			for(int i=0;i<nCount;i++)
			{
				pDC->MoveTo(npInputPoint[i],nBY);
				if(i == 0)
				{
					point[0].x = npInputPoint[i]+10;
					point[0].y = nBY+20;
					point[1].x = npInputPoint[i]-10;
					point[1].y = nBY+20;
					point[2].x = nX;
					point[2].y = nY;
				}
				else
				{
					point[0].x = npInputPoint[i];
					point[0].y = nBY+20;
					point[1].x = npInputPoint[i]+10;
					point[1].y = nBY+40;
					point[2].x = nX;
					point[2].y = nY;
				}
				pDC->PolyBezierTo(point,3);
			}
		}
	}

	nViewSizeY = nY;
	delete npInputPoint;
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nViewSizeX,nViewSizeY);
}

//CXISLTag* CXISLOprTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLOprTag::FindTag(POINT point,BOOL bOnly)
{
	CXISLTag* pTag;
	for(int i=0;i<m_InputList.GetCount();i++)
	{
		POSITION pos = m_InputList.FindIndex(i);
		CXISLOprItem* pOprItem = (CXISLOprItem*)m_InputList.GetAt(pos);

		pTag = pOprItem->FindTag(point,bOnly);
		if(pTag)
			return pTag;
	}

	return NULL;
}
